package cn.ninegame.ad.demo.activity;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.TextView;

import cn.ninegame.ad.demo.R;
import cn.ninegame.ad.demo.config.NGAdManagerHolder;
import cn.ninegame.ad.demo.util.Const;
import cn.ninegame.ad.demo.util.ToastUtil;
import cn.sirius.nga.ad.NGAdBase;
import cn.sirius.nga.ad.NGFullScreenVideoAd;
import cn.sirius.nga.config.AdPlacement;
import cn.sirius.nga.config.NGAdConstant;

/**
 * 融合demo，插全屏广告使用示例。更多功能参考接入文档。
 * <p>
 * 注意1：每次加载的广告，只能展示一次
 * <p>
 * 注意2：不要有遮挡物，否则影响广告结算
 * <p>
 * 接入步骤：
 * 1、创建AdPlacement对象
 * 2、创建NGAdBase对象
 * 3、创建加载、展示监听器
 * 4、加载广告
 * 5、加载成功后，展示广告
 * 6、在onDestroy中销毁广告
 */
public class MediationInterstitialFullActivity extends Activity {

    /**
     * 融合广告位（在NG平台的广告位，注意不是adn的代码位）
     */
    public String mMediaId;

    /**
     * 插全屏广告对象
     */
    private NGFullScreenVideoAd mNGFullScreenVideoAd;

    /**
     * 广告加载监听器
     */
    private NGAdBase.FullScreenVideoAdListener mFullScreenVideoListener;

    /**
     * 广告展示监听器
     */
    private NGFullScreenVideoAd.FullScreenVideoAdInteractionListener mFullScreenVideoAdInteractionListener;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.mediation_activity_interstitial_full);

        // 融合广告位（在NG平台的广告位，注意不是adn的代码位）
        this.mMediaId = getResources().getString(R.string.full_media_id);
        TextView tvMediationId = this.findViewById(R.id.tv_media_id);
        tvMediationId.setText(getString(R.string.ad_mediation_id, this.mMediaId));

        // 加载广告
        this.findViewById(R.id.bt_load).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View it) {
                loadInterstitialFullAd();
            }
        });

        // 展示广告
        this.findViewById(R.id.bt_show).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View it) {
                showInterstitialFullAd();
            }
        });
    }

    private void loadInterstitialFullAd() {
        /** 1、创建AdPlacement对象 */
        AdPlacement adPlacement = new AdPlacement.Builder()
                .setCodeId(this.mMediaId)
//                .setMediationAdPlacement(new NGMediationAdPlacement.Builder()
//                        .setMuted(false)//是否静音
//                        .setVolume(0.6f)//设置音量
//                        .setBidNotify(true)//竞价结果通知
//                        .build())
                .setOrientation(NGAdConstant.ORIENTATION_VERTICAL) // 横竖屏设置，与后台一致
                .build();

        /** 2、创建NGAdBase对象 需要传activity，切记!!*/
        NGAdBase adBaseLoader = NGAdManagerHolder.get().createAdNative(this);

        /** 3、创建加载、展示监听器 */
        initListeners();

        /** 4、加载广告 */
        /** 请求广告前，建议判断一次是否有网络，特别是激励广告 */
        adBaseLoader.loadFullScreenVideoAd(adPlacement, this.mFullScreenVideoListener);

        ToastUtil.show(MediationInterstitialFullActivity.this, "广告加载中，请稍后");
    }

    // 在加载成功后展示广告
    private void showInterstitialFullAd() {
        if (this.mNGFullScreenVideoAd == null) {
            Log.d(Const.TAG, "请先加载广告或等待广告加载完毕后再调用show方法");
            return;
        }
        /** 5、设置展示监听器 */
        this.mNGFullScreenVideoAd.setFullScreenVideoAdInteractionListener(this.mFullScreenVideoAdInteractionListener);

        /** 6、展示广告 */
        /** load成功后，先判断广告是否isReady，如果为false 可间隔一段时间再判断*/
        if (mNGFullScreenVideoAd.getMediationManager() != null && mNGFullScreenVideoAd.getMediationManager().isReady()) {
            this.mNGFullScreenVideoAd.showFullScreenVideoAd(MediationInterstitialFullActivity.this);
        }
    }

    private void initListeners() {
        // 广告加载监听器
        this.mFullScreenVideoListener = new NGAdBase.FullScreenVideoAdListener() {
            @Override
            public void onError(int code, String message) {
                /** code = 900400、3003：网络不可用，无法连接到服务器；建议引导用户联网后重试。*/
                Log.d(Const.TAG, "InterstitialFull onError code = " + code + " msg = " + message);
                ToastUtil.show(MediationInterstitialFullActivity.this, "广告加载失败 onError code = " + code + " msg = " + message);
            }

            @Override
            public void onFullScreenVideoAdLoad(NGFullScreenVideoAd ad) {
                Log.d(Const.TAG, "InterstitialFull onFullScreenVideoLoaded");
                mNGFullScreenVideoAd = ad;
                ToastUtil.show(MediationInterstitialFullActivity.this, "广告加载成功，可展示");
            }

            @Override
            public void onFullScreenVideoCached(NGFullScreenVideoAd ad) {
                Log.d(Const.TAG, "InterstitialFull onFullScreenVideoCached");
                mNGFullScreenVideoAd = ad;
                // 本条广告缓存完成
            }
        };

        // 广告展示监听器
        this.mFullScreenVideoAdInteractionListener = new NGFullScreenVideoAd.FullScreenVideoAdInteractionListener() {

            @Override
            public void onAdShow() {
                Log.d(Const.TAG, "InterstitialFull onAdShow");
            }

            @Override
            public void onAdVideoBarClick() {
                Log.d(Const.TAG, "InterstitialFull onAdVideoBarClick");
            }

            @Override
            public void onAdClose() {
                Log.d(Const.TAG, "InterstitialFull onAdClose");
                // 广告被关闭（包括主动、自动），执行下一流程
            }

            @Override
            public void onVideoComplete() {
                // 视频播放百分百
                Log.d(Const.TAG, "InterstitialFull onVideoComplete");
            }

            @Override
            public void onSkippedVideo() {
                Log.d(Const.TAG, "InterstitialFull onSkippedVideo");
            }
        };
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        /** 7、在onDestroy中销毁广告 */
        if (mNGFullScreenVideoAd != null && mNGFullScreenVideoAd.getMediationManager() != null) {
            mNGFullScreenVideoAd.getMediationManager().destroy();
        }
    }
}